<?php 

class Kat_member extends CI_Controller{

	function __construct(){
		parent::__construct();
		$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_kantor');
		$this->load->model('m_kat_member'); 
		$this->load->library('session');
		$this->load->library('upload');

		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
				<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
				<strong> Admin Bukan Admin </strong>Ulangi Kembali
				</div> ');

			redirect(base_url("")); 
			
		}


	}


	function index(){		
		$data['title1'] = 'Data Katagori Member'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Katagori member';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kat_member'] = $this->m_kat_member->kat_member(); 


		$this->load->view('master/header',$data); 
		$this->load->view('master/kat_member/v_kat_member');
		$this->load->view('master/footer',$data); 
	}
	

	public function code_tambah()
	{	 
		$data=array(
			'id_kat_member'=>  null,
			'nama_kat_member'=> $this->input->post('nama_kat_member'),
			'min_diskon'=> $this->input->post('min_diskon'),
			'diskon'=> $this->input->post('diskon'),


		);

		$this->db->insert('tb_kat_member',$data);
		$this->session->set_flashdata('msg','success');
		redirect('kat_member');





	}  


	public function code_hapus(){
		$id = $this->input->post('id');  

		$this->db->delete('tb_kat_member', array('id_kat_member' => $id)); 
		$this->session->set_flashdata('msg','success-hapus');
		redirect('kat_member');

	}


	public function code_ubah() {


		$data=array(

			'nama_kat_member'=> $this->input->post('nama_kat_member'),
			'min_diskon'=> $this->input->post('min_diskon'),
			'diskon'=> $this->input->post('diskon'),


		);

		$this->db->where('id_kat_member',$this->input->post('id'));
		$this->db->update('tb_kat_member',$data);
		$this->session->set_flashdata('msg','success-edit');
		redirect('kat_member');

	} 

}