<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kasirupdate extends CI_Controller {

    public function __construct() {
        parent::__construct();
        
        $this->load->model(['Barang_model','Transaksi_model','m_kantor','m_kontak','m_metode','m_member']);
        $this->load->helper('rupiah');
        $this->load->model('kasir_model_update');
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->helper(array('form', 'url','tanggal'));
        if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
          $this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
            <strong> Admin Bukan Admin </strong>Ulangi Kembali
            </div> ');

          redirect(base_url("")); 
          
        }
    }
    public function index() {
        $data['title'] = 'Sistem Kasir';
        $this->load->view('master/kasirupdate/index', $data);    
    }
    public function cari_barang() {
        $keyword = $this->input->get('keyword');
        $data = $this->kasir_model_update->cari_barang($keyword);
        echo json_encode($data);
    }

    


    public function get_barang_by_barcode() {
        $barcode = $this->input->get('barcode');
        $data = $this->kasir_model_update->get_barang_by_barcode($barcode);
        echo json_encode($data);
    }
     

    public function simpan_transaksi() {
        $this->form_validation->set_rules('sub_total', 'Sub Total', 'required|numeric');
        $this->form_validation->set_rules('potongan', 'Potongan', 'required|numeric');
        $this->form_validation->set_rules('bayar', 'Bayar', 'required|numeric');
        $this->form_validation->set_rules('kembali', 'Kembali', 'required|numeric');
        $this->form_validation->set_rules('metode_bayar', 'Metode Bayar', 'required');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode(['status' => 'error', 'message' => validation_errors()]);
            return;
        }

        $transaksi = [
            'sub_total' => $this->input->post('sub_total'),
            'potongan' => $this->input->post('potongan'),
            'bayar' => $this->input->post('bayar'),
            'kembali' => $this->input->post('kembali'),
            'status' => 'completed',
            'metode_bayar' => $this->input->post('metode_bayar'),
            'tanggal' => date('Y-m-d H:i:s')
        ];

        $detail = json_decode($this->input->post('detail'), true);

        if ($this->kasir_model->simpan_transaksi($transaksi, $detail)) {
            echo json_encode(['status' => 'success', 'message' => 'Transaksi berhasil disimpan']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Gagal menyimpan transaksi']);
        }
    }
    
    public function get_level_harga() {
        $id_barang = $this->input->get('id_barang');
        $data = $this->kasir_model->get_level_harga($id_barang);
        echo json_encode($data);
    }

}
