<?php 

class Bukukas extends CI_Controller{

	function __construct(){
		parent::__construct();
	 	$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_rak'); 
		$this->load->model('m_barang');
		$this->load->model('m_kantor');
		$this->load->model('m_satuan'); 
		$this->load->model('m_katagori');
		$this->load->library('session');
		$this->load->model('m_bukukas');
		$this->load->library('upload');
		 $this->load->library('pagination'); 
		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<strong> Admin Bukan Admin </strong>Ulangi Kembali
						</div> ');

			redirect(base_url("")); 
			
		}
	 
	 
	}

	 
 
	function index(){		
		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin_login']= $row->id;
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;

		$id_admin = $row->id;
		$level = $row->level;
		$id_kantor = $row->id_kantor;

		date_default_timezone_get('Asia/Jakarta');
		
		$data['title1'] = 'Data Buku Kas'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Buku Kas';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin();
		$data['admin_login'] = $this->m_admin->data_admin_login();  

		$data['transaksi'] = $this->m_bukukas->get_all($tgl_awal, $tgl_akhir);
		$data['totals'] = $this->m_bukukas->get_totals($tgl_awal, $tgl_akhir);
        $data['tgl_awal'] = $tgl_awal;
        $data['tgl_akhir'] = $tgl_akhir;

        $this->load->view('master/header',$data); 
        $this->load->view('master/bukukas/v_bukukas',$data);
        $this->load->view('master/footer',$data); 
    } 
    public function filter() {
    	$tgl_awal = $this->input->post('tgl_awal', true);
    	$tgl_akhir = $this->input->post('tgl_akhir', true);

    // Validasi input
    	if (empty($tgl_awal) || empty($tgl_akhir)) {
    		echo json_encode([
    			'error' => 'Tanggal tidak boleh kosong'
    		]);
    		return;
    	}

    // Validasi format tanggal
    	if (!DateTime::createFromFormat('Y-m-d', $tgl_awal) || !DateTime::createFromFormat('Y-m-d', $tgl_akhir)) {
    		echo json_encode([
    			'error' => 'Format tanggal tidak valid'
    		]);
    		return;
    	}

    	$transaksi = $this->m_bukukas->get_by_date_range($tgl_awal, $tgl_akhir);
    	$totals = $this->m_bukukas->get_totals($tgl_awal, $tgl_akhir);

    	echo json_encode([
    		'transaksi' => $transaksi,
    		'totals' => $totals
    	]);
    }

    public function tambah() {
        $data = [
            'keterangan' => $this->input->post('keterangan'),
            'jenis' => $this->input->post('jenis'),
            'nominal' => $this->input->post('nominal'),
            'date' => $this->input->post('tanggal'),
            'id_admin' => $this->session->userdata('id_admin')
        ];
        
        $insert_id = $this->m_bukukas->insert($data);
        $response = $this->m_bukukas->get_by_id($insert_id);
        echo json_encode($response);
    }

    public function edit($id) {
        $data = [
            'keterangan' => $this->input->post('keterangan'),
            'jenis' => $this->input->post('jenis'),
            'nominal' => $this->input->post('nominal'),
            'date' => $this->input->post('tanggal')
        ];
        
        $this->m_bukukas->update($id, $data);
        $response = $this->m_bukukas->get_by_id($id);
        echo json_encode($response);
    }

    public function hapus($id) {
        $this->m_bukukas->delete($id);
        echo json_encode(['status' => 'success']);
    }

	 
}