<?php 

class Kantor extends CI_Controller{

	function __construct(){
		parent::__construct();

	 	$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_kantor');
		$this->load->model('m_metode');
		$this->load->model('m_member');
		$this->load->model('m_barang'); 
		$this->load->model('m_supliyer'); 
		$this->load->library('session');
		$this->load->library('upload');
		 $this->load->library('pagination'); 
		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<strong> Admin Bukan Admin </strong>Ulangi Kembali
						</div> ');

			redirect(base_url("")); 
			
		}
	 
	 
	}

	 
	function index(){		
		$data['title1'] = 'Data Kantor/Gudang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kantor'] = $this->m_kantor->kantor(); 
		 
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/v_kantor');
		$this->load->view('master/footer',$data); 
	}
	public function singkron_cabang(){		
		$data['title1'] = 'Data Kantor/Gudang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kantor'] = $this->m_kantor->kantor(); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/singkron_cabang');
		$this->load->view('master/footer',$data); 
	}

	public function data_faktur(){		
		$data['title1'] = 'Data Faktur'; 	
		$data['title2'] = 'Faktu'; 	
		$data['title3'] = 'Tambah Data';
		 
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		 
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['faktur'] = $this->m_kantor->faktur(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kantor3'] = $this->m_kantor->kantor(); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/v_faktur');
		$this->load->view('master/footer',$data); 
	}
	public function data_dropout(){		
		$data['title1'] = 'Data Faktur'; 	
		$data['title2'] = 'Faktu'; 	
		$data['title3'] = 'Tambah Data';
		 
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['dropout'] = $this->m_kantor->dropout();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['dropout'] = $this->m_kantor->dropout(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kantor'] = $this->m_kantor->kantor(); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/v_dropout');
		$this->load->view('master/footer',$data); 
	}
	public function detail_faktur(){		
		$data['title1'] = 'Detail Faktur'; 	
		$data['title2'] = 'Faktur'; 	
		$data['title3'] = 'Tambah Data';

		$id_faktur= $this->uri->segment(3);

		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['faktur'] = $this->m_kantor->faktur();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['detail_faktur'] = $this->m_kantor->detail_faktur($id_faktur); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  
		$data['kantor'] = $this->m_kantor->kantor(); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/detail_faktur',$data);
		$this->load->view('master/footer',$data); 
	}
	public function detail_dropout(){       
        $data['title1'] = 'Detail Drop Out';    
        $data['title2'] = 'Faktur';     
        $data['title3'] = 'Tambah Data';

        $id_dropout= $this->uri->segment(3);

        $data['kontak'] = $this->m_kontak->kontak();
        $data['kantor'] = $this->m_kantor->kantor();
        $data['faktur'] = $this->m_kantor->faktur();
        $data['admin'] = $this->m_admin->data_admin(); 
        $data['detail_drop_out'] = $this->m_kantor->detail_drop_out($id_dropout); 
        $data['admin_login'] = $this->m_admin->data_admin_login();  
        $data['kantor'] = $this->m_kantor->kantor(); 
        $data['kantor2'] = $this->m_kantor->kantor();  
    
        $this->load->view('master/header',$data); 
        $this->load->view('master/kantor/detail_dropout',$data);
        $this->load->view('master/footer',$data); 
    }

	public function faktur(){		
		$data['title1'] = 'Data Faktur Masuk'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';

		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;
		$id_admin = $row->id;
		$id_kantor = $row->id_kantor;



		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;
		$data['kontak'] = $this->m_kontak->kontak();
		$data['supliyer'] = $this->m_supliyer->supliyer();
		$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
		$data['keranjang'] = $this->m_kantor->keranjang($id_admin,$id_kantor); 
	
		 
		$this->load->view('master/kantor/faktur',$data);
		 
	}
	public function faktur_keluar(){		
		$data['title1'] = 'Data Faktur Kirim Barang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';

		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;
		$id_admin = $row->id;
		$id_kantor = $row->id_kantor;



		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;
		$data['kontak'] = $this->m_kontak->kontak();
		$data['supliyer'] = $this->m_supliyer->supliyer();
		$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
		$data['keranjang'] = $this->m_kantor->keranjang($id_admin,$id_kantor); 
	
		 
		$this->load->view('master/kantor/faktur_keluar',$data);
		 
	}
	public function dropout(){       
        $data['title1'] = 'Data Drop Out Barang';    
        $data['title2'] = 'Ubah Data';  
        $data['title3'] = 'Tambah Data';
        $data['title4'] = 'Kantor';

        $username = $this->session->userdata("username");  
        $this->db->where('username',$username);
        $query = $this->db->get('tb_admin');
        $row = $query->row();
        $data['id_admin']= $row->id;
        $data['nama_admin']= $row->nama_admin;
        $data['id_kantor']= $row->id_kantor;
        $id_admin = $row->id;
        $id_kantor = $row->id_kantor;



        $this->db->where('id_kantor',$id_kantor);
        $query = $this->db->get('tb_kantor');
        $row = $query->row();
        $data['nama_kantor']= $row->nama_kantor;
        $data['kontak'] = $this->m_kontak->kontak();
        $data['supliyer'] = $this->m_supliyer->supliyer();
        // $data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
        $data['keranjang'] = $this->m_kantor->keranjang_dropout($id_admin,$id_kantor); 
    
         
        $this->load->view('master/kantor/dropout',$data);
         
    }
	public function hapus_keranjang($id){
		 
		
		//cek   barang sudah dientri di tb_jual_kasir
		$this->db->where('id',$id);
		$query = $this->db->get('tb_faktur_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_jum_jual = $kasir->jumlah;
		$cek_id_kantor = $kasir->id_kantor;

		$this->db->where('id_barang',$cek_id_barang);
        $this->db->where('id_kantor',$cek_id_kantor);
        $query = $this->db->get('tb_stok');
        $stok = $query->row();
        $cek_stok = $stok->stok_aplikasi;

		$update_stok =  $cek_stok   -  $cek_jum_jual;
            //update stok gudang
		$datax=array(

			'stok_aplikasi'=> $update_stok

		);
		$this->db->where('id_barang',$cek_id_barang);
		$this->db->where('id_kantor',$cek_id_kantor);
		$this->db->update('tb_stok',$datax);
			//barang belum entri keranjang

	    $this->db->delete('tb_faktur_detail_keranjang', array('id' => $id)); 
	    
	    redirect('kantor/faktur');
		
	} 
	public function hapus_keranjang_kirim($id){
		 
		
		//cek   barang sudah dientri di tb_jual_kasir
		$this->db->where('id',$id);
		$query = $this->db->get('tb_faktur_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_jum_jual = $kasir->jumlah;
		$cek_id_kantor = $kasir->id_kantor;

		$this->db->where('id_barang',$cek_id_barang);
        $this->db->where('id_kantor',$cek_id_kantor);
        $query = $this->db->get('tb_stok');
        $stok = $query->row();
        $cek_stok = $stok->stok_aplikasi;

		$update_stok =  $cek_stok   +  $cek_jum_jual;
            //update stok gudang
		$datax=array(

			'stok_aplikasi'=> $update_stok

		);
		$this->db->where('id_barang',$cek_id_barang);
		$this->db->where('id_kantor',$cek_id_kantor);
		$this->db->update('tb_stok',$datax);
			//barang belum entri keranjang

	    $this->db->delete('tb_faktur_detail_keranjang', array('id' => $id)); 
	    
	    redirect('kantor/faktur_keluar');
		
	} 
	public function code_simpan_keranjang()
	{	 
		

		$id_barang= $this->input->post('id_barang');
		$id_admin= $this->input->post('id_admin');
		$id_kantor= $this->input->post('id_kantor');
		$jum_masuk= $this->input->post('jumlah');
		$expired= $this->input->post('expired');

		//cek   barang sudah dientri di tb_jual_kasir
		$this->db->where('id_barang',$id_barang);
		$this->db->where('id_kantor',$id_kantor);
		$this->db->where('id_admin',$id_admin);
		$query = $this->db->get('tb_faktur_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_jum_jual = $kasir->jumlah;

		$new_jumlah = $cek_jum_jual + $jum_masuk;	

		$this->db->where('id_barang',$id_barang);
        $this->db->where('id_kantor',$id_kantor);
        $query = $this->db->get('tb_stok');
        $stok = $query->row();
        $cek_stok = $stok->stok_aplikasi;


		//cek barang apakah barang sudah masuk keranjang admin
		if($cek_id_barang == $id_barang ){
		 
			$update_stok = ($cek_stok - $cek_jum_jual) +  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);

			$data=array(
				 
				 
				'jumlah'=> $new_jumlah,
				 
				 
			);
			//update keranjang
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_admin',$id_admin);
			$this->db->where('id_kantor',$id_kantor);
			$this->db->update('tb_faktur_detail_keranjang',$data);

			redirect('kantor/faktur');

		}else{

			$update_stok =  $cek_stok   +  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);
			//barang belum entri keranjang
			 
			$data=array(
				'id'=>  null,
				'id_barang'=> $id_barang,
				'id_admin'=> $id_admin,
				'id_kantor'=> $id_kantor,
				'jumlah'=> $new_jumlah,
				'expired'=> $expired,
			 
				 
			);
			$this->db->insert('tb_faktur_detail_keranjang',$data);
			redirect('kantor/faktur');
		}	

	 	
	     
    } 
    public function code_simpan_keranjang_kirim()
	{	 
		

		$id_barang= $this->input->post('id_barang');
		$id_admin= $this->input->post('id_admin');
		$id_kantor= $this->input->post('id_kantor');
		$jum_masuk= $this->input->post('jumlah');
		$expired= $this->input->post('expired');

		//cek   barang sudah dientri di tb_jual_kasir
		$this->db->where('id_barang',$id_barang);
		$this->db->where('id_kantor',$id_kantor);
		$this->db->where('id_admin',$id_admin);
		$query = $this->db->get('tb_faktur_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_jum_jual = $kasir->jumlah;

		$new_jumlah = $cek_jum_jual + $jum_masuk;	

		$this->db->where('id_barang',$id_barang);
        $this->db->where('id_kantor',$id_kantor);
        $query = $this->db->get('tb_stok');
        $stok = $query->row();
        $cek_stok = $stok->stok_aplikasi;


		//cek barang apakah barang sudah masuk keranjang admin
		if($cek_id_barang == $id_barang ){
		 
			$update_stok = ($cek_stok + $cek_jum_jual) -  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);

			$data=array(
				 
				 
				'jumlah'=> $new_jumlah,
				 
				 
			);
			//update keranjang
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_admin',$id_admin);
			$this->db->where('id_kantor',$id_kantor);
			$this->db->update('tb_faktur_detail_keranjang',$data);

			redirect('kantor/faktur_keluar');

		}else{

			$update_stok =  $cek_stok   -  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);
			//barang belum entri keranjang
			 
			$data=array(
				'id'=>  null,
				'id_barang'=> $id_barang,
				'id_admin'=> $id_admin,
				'id_kantor'=> $id_kantor,
				'jumlah'=> $new_jumlah,
				'expired'=> $expired,
			 
				 
			);
			$this->db->insert('tb_faktur_detail_keranjang',$data);
			redirect('kantor/faktur_keluar');
		}	

	 	
	     
    } 
    public function hapus_keranjang_dropout($id){
		 
		 
		$this->db->where('id',$id);
		$query = $this->db->get('tb_dropout_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_id_kantor = $kasir->id_kantor;
		$cek_jum_jual = $kasir->jumlah;
		$cek_status = $kasir->status; 
		 
		
		$this->db->where('id_barang',$cek_id_barang);
		$this->db->where('id_kantor',$cek_id_kantor);
		$query1	 = $this->db->get('tb_stok');
		$row1 	 = $query1->row();
		$cek_stok	 = $row1->stok_aplikasi;

		$update_stok = $cek_stok + $cek_jum_jual;	 
		            //update stok gudang
		$datax=array(

			'stok_aplikasi'=> $update_stok

		);
		$this->db->where('id_barang',$cek_id_barang);
		$this->db->where('id_kantor',$cek_id_kantor);
		$this->db->update('tb_stok',$datax);

	    $this->db->delete('tb_dropout_detail_keranjang', array('id' => $id)); 
	    
	    redirect('kantor/dropout');
		
	} 
    public function code_simpan_keranjang_dropout()
	{	 
		

		$id_barang= $this->input->post('id_barang');
		$id_admin= $this->input->post('id_admin');
		$id_kantor= $this->input->post('id_kantor');
		$jum_masuk= $this->input->post('jumlah');
		$status= $this->input->post('status');

		//cek   barang sudah dientri di tb_jual_kasir
		$this->db->where('id_barang',$id_barang);
		$this->db->where('id_kantor',$id_kantor);
		$this->db->where('id_admin',$id_admin);
		$query = $this->db->get('tb_dropout_detail_keranjang');
		$kasir = $query->row();
		$cek_id_barang = $kasir->id_barang;
		$cek_jum_jual = $kasir->jumlah;
		$cek_status = $kasir->status;

		$new_jumlah = $cek_jum_jual + $jum_masuk;	 
		//cek barang apakah barang sudah masuk keranjang admin

		$this->db->where('id_barang',$id_barang);
		$this->db->where('id_kantor',$id_kantor);
		$query1	 = $this->db->get('tb_stok');
		$row1 	 = $query1->row();
		$cek_stok	 = $row1->stok_aplikasi;


		if($cek_id_barang == $id_barang and $cek_status == $status ){
		 
			$update_stok =  ($cek_stok+ $cek_jum_jual)   -  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);
			//barang belum entri keranjang

			$data=array(
				 
				 
				'jumlah'=> $new_jumlah,
				 
				 
			);
			//update keranjang
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_admin',$id_admin);
			$this->db->where('id_kantor',$id_kantor);
			$this->db->update('tb_dropout_detail_keranjang',$data);

			redirect('kantor/dropout');

		}else{
			//barang belum entri keranjang
			 $update_stok =  $cek_stok   -  $new_jumlah;
            //update stok gudang
                   $datax=array(

                    'stok_aplikasi'=> $update_stok

                  );
                   $this->db->where('id_barang',$id_barang);
                   $this->db->where('id_kantor',$id_kantor);
                   $this->db->update('tb_stok',$datax);
			//barang belum entri keranjang
			$data=array(
				'id'=>  null,
				'id_barang'=> $id_barang,
				'id_admin'=> $id_admin,
				'id_kantor'=> $id_kantor,
				'jumlah'=> $jum_masuk,
				'status'=> $status,
			 
				 
			);
			$this->db->insert('tb_dropout_detail_keranjang',$data);
			redirect('kantor/dropout');
		}	

	 	
	     
    } 
    function code_simpan_faktur (){

    	$id_admin= $this->input->post('id_admin');
    	$id_kantor= $this->input->post('id_kantor');
    	$id_faktur= $this->input->post('id_faktur');
    	$id_supliyer= $this->input->post('id_supliyer');
    	$keterangan= $this->input->post('keterangan');
    	$nominal= $this->input->post('nominal');
    	$jatuh_tempo= $this->input->post('jatuh_tempo');
    	$status= $this->input->post('status');
     	$jenis_faktur= $this->input->post('jenis');

		$sql = "SELECT * FROM tb_faktur_detail_keranjang  where id_admin='$id_admin' and id_kantor='$id_kantor' ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {

			// -------------------------------------------
			$id_barang = $data->id_barang;
			$jum_keluar = $data->jumlah;
			// -------------------------------------------
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_kantor',$id_kantor);
			$query1	 = $this->db->get('tb_stok');
			$row1 	 = $query1->row();
			$cek_stok	 = $row1->stok_aplikasi;

			$new_stok =   $cek_stok + $jum_keluar ;

			//-----------------------------------------
			// $datax=array(

			// 	'stok_aplikasi'=> $new_stok

			// );
			// $this->db->where('id_barang',$id_barang);
			// $this->db->where('id_kantor',$id_kantor);
			// $this->db->update('tb_stok',$datax);


			$data1=array(

				'id'=>null,

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				 
				'jumlah'			=>  $data->jumlah,
				'expired'			=>  $data->expired,
				'id_admin'			=>  $data->id_admin, 	
				'date'				=>  $data->date,
				'id_faktur'			=>  $id_faktur,
				'stok_awal'			=>  $cek_stok,
				'stok_akhir'		=>  $new_stok
			);

			$this->db->insert('tb_faktur_detail',$data1);
			
 
			// if($jenis_faktur == "masuk"){
			// 	$new_stok =   $cek_stok + $jum_keluar ;
			// }else{
			// 	$new_stok =   $cek_stok - $jum_keluar ;
			// }
			 // if($jenis_faktur == "masuk"){
				
			// }else{
			// 	$new_stok =   $cek_stok - $jum_keluar ;
			// }
			//update stok gudang
			


        	//input data barmasuk
			
			

			// -------------------------------------------
        	//input data history
			$data2=array(

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				'jumlah'			=>  $data->jumlah,
				'id_admin'			=>  $data->id_admin,
				'date'				=>  $data->date,
				'keterangan'		=>  'masuk',
				
				'id_transaksi'		=>  $id_faktur, 

			);

			$this->db->insert('tb_history_barang_in_out',$data2);

			//input ke informasi expired
			$datay=array(

				'id_barang'			=>  $data->id_barang, 
				'id_admin'			=>  $data->id_admin, 
				'id_kantor'			=>  $data->id_kantor, 
				'date'				=>  $data->date,
				 
				'expired_date'		=>  $data->expired,

			);

			$this->db->insert('tb_info_expired',$datay);


			

		}
		// simpan 
		$data4=array(
			
			'id_faktur'=>  $id_faktur, 
			'id_admin'=>  $id_admin, 
			'id_kantor'=>  $this->input->post('id_kantor'), 
			'id_supliyer' =>$id_supliyer,
			'keterangan'=>  $this->input->post('keterangan'),
			
			'nominal'=>  $this->input->post('nominal'), 
			
			'jatuh_tempo'=>  $this->input->post('jatuh_tempo'), 
			'jenis'=>  $this->input->post('jenis'), 
			'supir'=>  $this->input->post('supir'), 
			'status'=>  $this->input->post('status') 
			 
			
		);
		$this->db->insert('tb_faktur',$data4); 

	 
		//hapus 
		$hapus = "DELETE FROM tb_faktur_detail_keranjang where id_admin='$id_admin' and id_kantor='$id_kantor'    ";
		$data = $this->db->query($hapus);
		

		 $this->session->set_flashdata('msg','success');
		  redirect('kantor/data_faktur');
    }
     function code_simpan_faktur_kirim (){

    	$id_admin= $this->input->post('id_admin');
    	$id_kantor= $this->input->post('id_kantor');
    	$id_faktur= $this->input->post('id_faktur');
    	$id_supliyer= $this->input->post('id_supliyer');
    	$keterangan= $this->input->post('keterangan');
    	$nominal= $this->input->post('nominal');
    	$jatuh_tempo= $this->input->post('jatuh_tempo');
    	$status= $this->input->post('status');
     	$jenis_faktur= $this->input->post('jenis');

		$sql = "SELECT * FROM tb_faktur_detail_keranjang  where id_admin='$id_admin' and id_kantor='$id_kantor' ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {

			// -------------------------------------------
			$id_barang = $data->id_barang;
			$jum_keluar = $data->jumlah;
			// -------------------------------------------
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_kantor',$id_kantor);
			$query1	 = $this->db->get('tb_stok');
			$row1 	 = $query1->row();
			$cek_stok	 = $row1->stok_aplikasi;

			$new_stok =   $cek_stok + $jum_keluar ;

			//-----------------------------------------
			// $datax=array(

			// 	'stok_aplikasi'=> $new_stok

			// );
			// $this->db->where('id_barang',$id_barang);
			// $this->db->where('id_kantor',$id_kantor);
			// $this->db->update('tb_stok',$datax);


			$data1=array(

				'id'=>null,

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				 
				'jumlah'			=>  $data->jumlah,
				'expired'			=>  $data->expired,
				'id_admin'			=>  $data->id_admin, 	
				'date'				=>  $data->date,
				'id_faktur'			=>  $id_faktur,
				'stok_awal'			=>  $cek_stok,
				'stok_akhir'		=>  $new_stok
			);

			$this->db->insert('tb_faktur_detail',$data1);
			
 
			// if($jenis_faktur == "masuk"){
			// 	$new_stok =   $cek_stok + $jum_keluar ;
			// }else{
			// 	$new_stok =   $cek_stok - $jum_keluar ;
			// }
			 // if($jenis_faktur == "masuk"){
				
			// }else{
			// 	$new_stok =   $cek_stok - $jum_keluar ;
			// }
			//update stok gudang
			


        	//input data barmasuk
			
			

			// -------------------------------------------
        	//input data history
			$data2=array(

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				'jumlah'			=>  $data->jumlah,
				'id_admin'			=>  $data->id_admin,
				'date'				=>  $data->date,
				'keterangan'		=>  'masuk',
				
				'id_transaksi'		=>  $id_faktur, 

			);

			$this->db->insert('tb_history_barang_in_out',$data2);

			//input ke informasi expired
			$datay=array(

				'id_barang'			=>  $data->id_barang, 
				'id_admin'			=>  $data->id_admin, 
				'id_kantor'			=>  $data->id_kantor, 
				'date'				=>  $data->date,
				 
				'expired_date'		=>  $data->expired,

			);

			$this->db->insert('tb_info_expired',$datay);


			

		}
		// simpan 
		$data4=array(
			
			'id_faktur'=>  $id_faktur, 
			'id_admin'=>  $id_admin, 
			'id_kantor'=>  $this->input->post('id_kantor'), 
			'id_supliyer' =>$id_supliyer,
			'keterangan'=>  $this->input->post('keterangan'),
			
			'nominal'=>  $this->input->post('nominal'), 
			
			'jatuh_tempo'=>  $this->input->post('jatuh_tempo'), 
			'jenis'=>  $this->input->post('jenis'), 
			'supir'=>  $this->input->post('supir'), 
			'status'=>  $this->input->post('status') 
			 
			
		);
		$this->db->insert('tb_faktur',$data4); 

	 
		//hapus 
		$hapus = "DELETE FROM tb_faktur_detail_keranjang where id_admin='$id_admin' and id_kantor='$id_kantor'    ";
		$data = $this->db->query($hapus);
		

		 $this->session->set_flashdata('msg','success');
		  redirect('kantor/data_faktur');
    }
    function code_restok_faktur (){
		$id_faktur = $this->uri->segment(3);
    	 
		$sql = "SELECT * FROM tb_faktur_detail  where id_faktur='$id_faktur'   ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {
        	//input data barmasuk

			$id_admin = $data->id_admin;
			$id_kantor = $data->id_kantor;

			$id_barang = $data->id_barang;
			$jumlah = $data->jumlah;
			$date = $data->date;
			$expired = $data->expired;

						

						// -------------------------------------------
			        	//input data history
						$data2=array(

							'id_barang'			=>  $id_barang, 
							'id_kantor'			=>  $id_kantor,
							'jumlah'			=>  $jumlah,
							'id_admin'			=>  $id_admin,
							'date'				=>  $date,
							'keterangan'		=>  'masuk-restok',
							
							'id_transaksi'		=>  $id_faktur, 

						);

						$this->db->insert('tb_history_barang_in_out',$data2);


						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$query1	 = $this->db->get('tb_stok');
						$row1 	 = $query1->row();
						$cek_stok	 = $row1->stok_aplikasi;


						$new_stok =   $cek_stok + $jumlah ;
					 
						 
						 
						//update stok gudang
						$datax=array(

							'stok_aplikasi'=> $new_stok

						);
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$this->db->update('tb_stok',$datax);
						//input ke informasi expired
						$datay=array(

							'id_barang'			=>  $id_barang, 
							'id_admin'			=>  $id_admin, 
							'id_kantor'			=>  $id_kantor, 
							'date'				=>  $date,
							 
							'expired_date'		=>  $expired,

						);

						$this->db->insert('tb_info_expired',$datay);

			 

		}
		 


		  redirect('kantor/data_faktur');
    }
     function code_restok_faktur_satu (){
		$id_faktur_detail = $this->uri->segment(3);
    	 
		$sql = "SELECT * FROM tb_faktur_detail  where id='$id_faktur_detail'   ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {
        	//input data barmasuk
			$id_faktur = $data->id_faktur;
			$id_admin = $data->id_admin;
			$id_kantor = $data->id_kantor;

			$id_barang = $data->id_barang;
			$jumlah = $data->jumlah;
			$date = $data->date;
			$expired = $data->expired;

						

						// -------------------------------------------
			        	//input data history
						$data2=array(

							'id_barang'			=>  $id_barang, 
							'id_kantor'			=>  $id_kantor,
							'jumlah'			=>  $jumlah,
							'id_admin'			=>  $id_admin,
							'date'				=>  $date,
							'keterangan'		=>  'masuk-restok',
							
							'id_transaksi'		=>  $id_faktur, 

						);

						$this->db->insert('tb_history_barang_in_out',$data2);


						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$query1	 = $this->db->get('tb_stok');
						$row1 	 = $query1->row();
						$cek_stok	 = $row1->stok_aplikasi;
						
						
						$new_stok =   $cek_stok + $jumlah ;
					 
						 
						 
						//update stok gudang
						$datax=array(

							'stok_aplikasi'=> $new_stok

						);
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$this->db->update('tb_stok',$datax);

						///Update Stok akhir dan stok akhir pada 
						$datasx=array(
							'stok_awal'=> $cek_stok,
							'stok_akhir'=> $new_stok

						);
						$this->db->where('id',$id_faktur_detail);
						$this->db->update('tb_faktur_detail',$datasx);


						//input ke informasi expired
						$datay=array(

							'id_barang'			=>  $id_barang, 
							'id_admin'			=>  $id_admin, 
							'id_kantor'			=>  $id_kantor, 
							'date'				=>  $date,
							 
							'expired_date'		=>  $expired,

						);

						$this->db->insert('tb_info_expired',$datay);

			 

		}
		 

		 $this->session->set_flashdata('msg','success');
		  redirect('kantor/detail_faktur/'.$id_faktur);
    }
    
    function code_lunas_faktur (){

    	 
    	$id_faktur=$this->uri->segment(3);
    	$data=array(

    		
    		'status'=> 'LUNAS'
    	);

    	$this->db->where('id_faktur', $id_faktur);
    	$this->db->update('tb_faktur',$data);


		 
		$this->session->set_flashdata('msg','success');	
		redirect('kantor/data_faktur');
    }
    function code_hapus_faktur (){

    	 
     $id_faktur=$this->uri->segment(3);

		$sql = "SELECT * FROM tb_faktur  where   id_faktur='$id_faktur' ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {
					$car_faktur = $data->id_faktur;
					$jenis_faktur = $data->jenis;
        			$sqldetail = "SELECT * FROM tb_faktur_detail  where   id_faktur='$car_faktur' ";
					$cari2 = $this->db->query($sqldetail)->result();
					foreach ($cari2 as $data_detail) {
						 
						$jum_barang = $data_detail->jumlah;
						$id_barang = $data_detail->id_barang;
						$id_kantor = $data_detail->id_kantor;


						//update stok								
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$query1	 = $this->db->get('tb_stok');
						$row1 	 = $query1->row();
						$cek_stok	 = $row1->stok_aplikasi;
						
						if($jenis_faktur == 'masuk'){
							$new_stok =   $cek_stok - $jum_barang ;
						}else{
							$new_stok =   $cek_stok + $jum_barang ;
						}
						
						//update stok gudang
						$datax=array(

							'stok_aplikasi'=> $new_stok

						);
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$this->db->update('tb_stok',$datax);
					}

		}
		//hapus
		$this->db->delete('tb_faktur_detail', array('id_faktur' => $data->id_faktur)); 
		$this->db->delete('tb_faktur', array('id_faktur' => $data->id_faktur)); 
		$this->db->delete('tb_history_barang_in_out', array('id_transaksi' => $data->id_faktur)); 
		$this->session->set_flashdata('msg','success-hapus');	
		redirect('kantor/data_faktur');
    }
    function code_hapus_dropout (){

    	 
     $id_dropout=$this->uri->segment(3);

		$sql = "SELECT * FROM tb_dropout  where   id_dropout='$id_dropout' ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {
					$car_dropout = $data->id_dropout;
        			$sqldetail = "SELECT * FROM tb_dropout_detail  where   id_dropout='$car_dropout' ";
					$cari2 = $this->db->query($sqldetail)->result();
					foreach ($cari2 as $data_detail) {
						 
						$jum_barang = $data_detail->jumlah;
						$id_barang = $data_detail->id_barang;
						$id_kantor = $data_detail->id_kantor;

						//update stok								
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$query1	 = $this->db->get('tb_stok');
						$row1 	 = $query1->row();
						$cek_stok	 = $row1->stok_aplikasi;
						$new_stok =   $cek_stok + $jum_barang ;
						 
						
						//update stok gudang
						$datax=array(

							'stok_aplikasi'=> $new_stok

						);
						$this->db->where('id_barang',$id_barang);
						$this->db->where('id_kantor',$id_kantor);
						$this->db->update('tb_stok',$datax);
					}

		}
		//hapus
		$this->db->delete('tb_dropout_detail', array('id_dropout' => $data->id_dropout)); 
		$this->db->delete('tb_dropout', array('id_dropout' => $data->id_dropout)); 
		$this->db->delete('tb_history_barang_in_out', array('id_transaksi' => $data->id_dropout)); 
		$this->session->set_flashdata('msg','success-hapus');	
		redirect('kantor/data_dropout');
    }
    function code_simpan_dropout (){

    	$id_admin= $this->input->post('id_admin');
    	$id_kantor= $this->input->post('id_kantor');
    	$keterangan= $this->input->post('keterangan');
   		$status= $this->input->post('status');


    	$date = date("dYm");
    	$query = $this->db->query("SELECT max(id_dropout) as max_id FROM tb_dropout WHERE id_dropout LIKE '$date%' ");
    	$row = $query->row_array();
    	$max_id = $row['max_id'];
    	$max_id1 =(int) substr($max_id,8,2);
    	$kode_tr = $max_id1 +1;
    	$kode_new = $date.sprintf("%02s",$kode_tr);
    	 
    	
     

		$sql = "SELECT * FROM tb_dropout_detail_keranjang  where id_admin='$id_admin' and id_kantor='$id_kantor' ";
		$cari = $this->db->query($sql)->result();
		foreach ($cari as $data) {
        	//input data barmasuk
			$data1=array(

				'id'=>null,

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				 
				'jumlah'			=>  $data->jumlah,
				'status'			=>  $data->status,
				'id_admin'			=>  $data->id_admin, 	
				'date'				=>  $data->date,
				

				'id_dropout'			=>  $kode_new
			);

			$this->db->insert('tb_dropout_detail',$data1);


        	//input data history
			$data2=array(

				'id_barang'			=>  $data->id_barang, 
				'id_kantor'			=>  $data->id_kantor,
				'jumlah'			=>  $data->jumlah,
				'id_admin'			=>  $data->id_admin,
				'date'				=>  $data->date,
				'keterangan'		=>  $data->status,
				
				'id_transaksi'		=>  $kode_new, 

			);

			$this->db->insert('tb_history_barang_in_out',$data2);

		 


			$id_barang = $data->id_barang;
			$jum_keluar = $data->jumlah;

			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_kantor',$id_kantor);
			$query1	 = $this->db->get('tb_stok');
			$row1 	 = $query1->row();
			$cek_stok	 = $row1->stok_aplikasi;
			$jenis_faktur= $this->input->post('jenis');
		  
			$new_stok =   $cek_stok - $jum_keluar ;
			 

			

			//update stok gudang
			$datax=array(

				'stok_aplikasi'=> $new_stok

			);
			$this->db->where('id_barang',$id_barang);
			$this->db->where('id_kantor',$id_kantor);
			$this->db->update('tb_stok',$datax);

		}
		// simpan 
		$data4=array(
			
			'id_dropout'=>  $kode_new, 
			'id_admin'=>  $id_admin, 
			'id_kantor'=>  $this->input->post('id_kantor'), 
			 
			'keterangan'=>  $this->input->post('keterangan'),
			'status'=>  $this->input->post('status') 
			 
			
		);
		$this->db->insert('tb_dropout',$data4); 

	 
		//hapus 
		$hapus = "DELETE FROM tb_dropout_detail_keranjang where id_admin='$id_admin' and id_kantor='$id_kantor'    ";
		$data = $this->db->query($hapus);
		


		  redirect('kantor/data_dropout');
    }
    public function tampil_stok_satuan(){
        
         $username = $this->session->userdata("username"); 
         
         if( $username !='rohim118899@gmail.com'){
              redirect('home');
         }else{
              $this->load->library('datatables'); //load library ignited-dataTable
               $this->load->model('crud_model_stok');		
        		$data['title1'] = 'Data Stok Kantor/Gudang'; 	
        		$data['title2'] = 'Ubah Data'; 	
        		$data['title3'] = 'Tambah Data';
        		$data['title4'] = 'Kantor';
        		$data['kontak'] = $this->m_kontak->kontak();
        		$data['kantor'] = $this->m_kantor->kantor();
        		$data['admin'] = $this->m_admin->data_admin(); 
        		$data['admin_login'] = $this->m_admin->data_admin_login();  
        
        		$username = $this->session->userdata("username");  
        		$this->db->where('username',$username);
        		$query = $this->db->get('tb_admin');
        		$row = $query->row();
        		$data['id_admin']= $row->id;
        		$data['nama_admin']= $row->nama_admin;
        		$data['id_kantor']= $row->id_kantor;
        
        		$id_kantor = $row->id_kantor;
        
        		$this->db->where('id_kantor',$id_kantor);
        		$query = $this->db->get('tb_kantor');
        		$row = $query->row();
        		$data['nama_kantor']= $row->nama_kantor;
        
                    		  
        
        		$data['barang'] = $this->m_kantor->kantor_stok($id_kantor); 
        		$data['kantor2'] = $this->m_kantor->kantor();  
        	
        		$this->load->view('master/header',$data); 
        		$this->load->view('master/kantor/tampil_stok_kantor_satuan');
        		$this->load->view('master/footer',$data); 
         }
      
	}
	public function tampil_stok(){
       $this->load->library('datatables'); //load library ignited-dataTable
       $this->load->model('crud_model_stok');		
		$data['title1'] = 'Data Stok Kantor/Gudang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  

		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;

		$id_kantor = $row->id_kantor;

		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;

            		  

		$data['barang'] = $this->m_kantor->kantor_stok($id_kantor); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/tampil_stok_kantor');
		$this->load->view('master/footer',$data); 
	} 
	public function code_ubah_stok() {
      
        
    	$data=array(
    	 
    		'stok_aplikasi'=> $this->input->post('stok_aplikasi'),
    	
    	);

    	$this->db->where('id_stok',$this->input->post('id_stok'));
        $this->db->update('tb_stok',$data);
        $this->session->set_flashdata('msg','success-edit');
    	redirect('kantor/tampil_stok');
	 
	} 
	public function tampil_stok_kantor(){		
		$data['title1'] = 'Data Stok Kantor/Gudang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  

		$id_kantor = $this->input->post('id_kantor');
		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;

            		  

		$data['barang'] = $this->m_kantor->kantor_stok(); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/tampil_stok_kantor');
		$this->load->view('master/footer',$data); 
	}

	public function stok(){		
		$data['title1'] = 'Data Stok Kantor/Gudang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  



		$username = $this->session->userdata("username");
		$this->db->where('username',$username);
		$queryy = $this->db->get('tb_admin');
		$rowss = $queryy->row();
		$id_kantor = $rowss->id_kantor;



		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;

            		  

		$data['barang'] = $this->m_kantor->kantor_stok_in($id_kantor); 
		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/tampil_stok_kantor_in');
		$this->load->view('master/footer',$data); 
	}
	public function all_stok(){		
		$data['title1'] = 'Data Stok Semua Barang'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Kantor';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['admin_login'] = $this->m_admin->data_admin_login();  



		$username = $this->session->userdata("username");
		$this->db->where('username',$username);
		$queryy = $this->db->get('tb_admin');
		$rowss = $queryy->row();
		$id_kantor = $rowss->id_kantor;



		$this->db->where('id_kantor',$id_kantor);
		$query = $this->db->get('tb_kantor');
		$row = $query->row();
		$data['nama_kantor']= $row->nama_kantor;

            		  

		$data['barang'] = $this->m_kantor->kantor_stok_all(); 


		$data['kantor2'] = $this->m_kantor->kantor();  
	
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/tampil_stok_kantor_all');
		$this->load->view('master/footer',$data); 
	}
	 
	public function code_singkron(){
		$id_kantor = $this->input->post('id_kantor');
 
	     
		  $sql = "SELECT
		  tb_barang.id
		  FROM
		  tb_barang
		  WHERE
		  NOT EXISTS (SELECT * FROM tb_stok 
		  	WHERE
		  	tb_barang.id = tb_stok.id_barang AND tb_stok.id_kantor='$id_kantor' )";
		  $cari = $this->db->query($sql)->result();
		  foreach ($cari as $data) {


		  	$data1=array(

		  		'id_stok'=>null,
	  			'id_kantor'			=> $id_kantor,
		  		'id_barang'				=>  $data->id,

		  	);

		  	$this->db->insert('tb_stok',$data1);


		  }
		  $this->session->set_flashdata('msg','success-singkron');
		  redirect('kantor/singkron_cabang');
       	
		
	}
	public function code_hapus(){
		$id = $this->input->post('id');  
		 
	    $this->db->delete('tb_kantor', array('id_kantor' => $id)); 
	  	$this->session->set_flashdata('msg','success-hapus');
	    redirect('kantor');
		
	}
	 
	public function code_tambah()
	{	 
		$data=array(
			'id_kantor'=>  null,
			'nama_kantor'=> $this->input->post('nama_kantor'),
			'propinsi'=> $this->input->post('propinsi'),
			'kab_kota'=> $this->input->post('kab_kota'),
			'kecamatan'=> $this->input->post('kecamatan'),
			'kode_pos'=> $this->input->post('kode_pos'),
			'tlp'=> $this->input->post('tlp'),
			'alamat'=> $this->input->post('alamat'),
			 
		);

		$this->db->insert('tb_kantor',$data);
		$this->session->set_flashdata('msg','success');
		redirect('kantor');


 
        
        
    }  
     
	public function code_ubah() {
      
        
    	$data=array(
    	 
    		'nama_kantor'=> $this->input->post('nama_kantor'),
			'propinsi'=> $this->input->post('propinsi'),
			'kab_kota'=> $this->input->post('kab_kota'),
			'kecamatan'=> $this->input->post('kecamatan'),
			'kode_pos'=> $this->input->post('kode_pos'),
			'tlp'=> $this->input->post('tlp'),
			'alamat'=> $this->input->post('alamat'),


    	);

    	$this->db->where('id_kantor',$this->input->post('id'));
        $this->db->update('tb_kantor',$data);
        $this->session->set_flashdata('msg','success-edit');
    	redirect('kantor');
	 
	} 
	function stok_opname_rak(){		
		 

		 
		$data['title1'] = 'Data Laporan Stok Opname'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Laporan Data';
		$data['title4'] = 'Supliyer';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['kantor1'] = $this->m_kantor->kantor();
		$data['kantor2'] = $this->m_kantor->kantor();
		$data['kantorxx'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
		$data['rak'] = $this->m_admin->data_rak(); 
		$data['rak2'] = $this->m_admin->data_rak();
	 	$data['admin_login'] = $this->m_admin->data_admin_login(); 
		 
		$this->load->view('master/header',$data); 
		$this->load->view('master/kantor/form_laporan_stokopname');
		$this->load->view('master/footer',$data); 
		
		 
		  
	}
	function cetak_stok_opname(){		
		 

		 
		$data['title1'] = 'Cetak Lembar Stok Opname Barang'; 	
	 
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['barang'] = $this->m_barang->barang_nama(); 
		$data['kantor2'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin(); 
	 	$data['admin_login'] = $this->m_admin->data_admin_login(); 

	 	$id_rak=$this->input->post('id_rak');
	 	$this->db->where('id_rak',$id_rak);
		$query = $this->db->get('tb_rak');
		$row = $query->row();
		$data['nama_rak_tampil']= $row->nama_rak;
		 
		$data['barang'] = $this->m_admin->tampil_data_rak($id_rak);  
		 
		$this->load->view('master/kantor/cetak_stok_opname',$data);
		 
		 
		  
	} 
	 
}