<?php

    class Datatables extends CI_Controller
    {
        public function __construct()
        {  
            parent::__construct();
            $this->load->model('M_Datatables');
            $this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
            $this->load->model('m_login'); 
            $this->load->model('m_admin'); 
            $this->load->model('m_rak'); 
            $this->load->model('m_selfing');
            $this->load->model('m_barang');
            $this->load->model('m_kantor');
            $this->load->model('m_satuan'); 
            $this->load->model('m_katagori');
            $this->load->library('session');
            $this->load->library('upload');
            $this->load->library('pagination'); 
           
             $this->load->helper(array('form', 'url','tanggal'));
             if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
                $this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                    <strong> Admin Bukan Admin </strong>Ulangi Kembali
                    </div> ');

                redirect(base_url("")); 
                
            }
        }

        public function index()
        {
            $username = $this->session->userdata("username");  
            $this->db->where('username',$username);
            $query = $this->db->get('tb_admin');
            $row = $query->row();
            $data['id_admin_login']= $row->id;


            $data['title1'] = 'Data Barang';    
            $data['title2'] = 'Ubah Data';  
            $data['title3'] = 'Tambah Data';
            $data['title4'] = 'Barang';
            $data['kontak'] = $this->m_kontak->kontak();
            $data['kantor'] = $this->m_kantor->kantor();
            $data['admin'] = $this->m_admin->data_admin(); 
            $data['katagori'] = $this->m_katagori->katagori();
            $data['rak'] = $this->m_rak->rak(); 
            $data['selfing'] = $this->m_selfing->selfing(); 
            $data['satuan'] = $this->m_satuan->satuan();
            $data['admin_login'] = $this->m_admin->data_admin_login();  
        // $data['barang'] = $this->m_barang->barang(); 

          
            $this->load->view('master/header',$data); 
            $this->load->view('master/data_barang/home',$data);
            $this->load->view('master/footer',$data); 
           
        }

        public function onetable()
        {
            $this->load->view('master/data_barang/onetable');

        }

        public function tablewhere()
        {
            $this->load->view('master/data_barang/tablewhere');

        }

        public function tablequery()
        {
            $this->load->view('master/data_barang/tablequery');

        }

        // datatable with csrf
        public function csrf()
        {
            $this->load->view('master/data_barang/csrf');

        }


        function view_data()
        {
            $tables = "artikel";
            $search = array('judul','kategori','penulis','tgl_posting');
            // jika memakai IS NULL pada where sql
            $isWhere = null;
            // $isWhere = 'artikel.deleted_at IS NULL';
            header('Content-Type: application/json');
            echo $this->M_Datatables->get_tables($tables,$search,$isWhere);
        }

        function view_data_where()
        {
            $tables = "artikel";
            $search = array('judul','kategori','penulis','tgl_posting');
            $where  = array('kategori' => 'php');
            // jika memakai IS NULL pada where sql
            $isWhere = null;
            // $isWhere = 'artikel.deleted_at IS NULL';
            header('Content-Type: application/json');
            echo $this->M_Datatables->get_tables_where($tables,$search,$where,$isWhere);
        }

        function view_data_query()
        {
            $query  = "SELECT kategori.nama_kategori AS nama_kategori, subkat.* FROM subkat 
                       JOIN kategori ON subkat.id_kategori = kategori.id_kategori";
            $search = array('nama_kategori','subkat','tgl_add');
            $where  = null; 
            // $where  = array('nama_kategori' => 'Tutorial');
            
            // jika memakai IS NULL pada where sql
            $isWhere = null;
            // $isWhere = 'artikel.deleted_at IS NULL';
            header('Content-Type: application/json');
            echo $this->M_Datatables->get_tables_query($query,$search,$where,$isWhere);
        }

        // datatable with csrf data json
        function view_data_query_csrf()
        {
			$csrf_name = $this->security->get_csrf_token_name();
			$csrf_hash = $this->security->get_csrf_hash(); 
            $query  = "SELECT tb_katagori.nama_katagori AS nama_katagori, tb_barang.* FROM tb_barang 
                       JOIN tb_katagori ON tb_barang.id_katagori = tb_katagori.id_katagori";
            $search = array('nama_katagori','nama_barang','barcode_ecer');
            $where  = null; 
            // $where  = array('nama_kategori' => 'Tutorial');
            
            // jika memakai IS NULL pada where sql
            $isWhere = null;
            // $isWhere = 'artikel.deleted_at IS NULL';
            header('Content-Type: application/json');
            echo $this->M_Datatables->get_tables_query($query,$search,$where,$isWhere,$csrf_name,$csrf_hash);
        }
    }
?>