<?php 

class Bukukas extends CI_Controller{

	function __construct(){
		parent::__construct();
	 	$this->load->model('m_kontak');/* sesuaikan dengan nama file pada model */
		$this->load->model('m_login'); 
		$this->load->model('m_admin'); 
		$this->load->model('m_rak'); 
		$this->load->model('m_barang');
		$this->load->model('m_kantor');
		$this->load->model('m_satuan'); 
		$this->load->model('m_katagori');
		$this->load->library('session');
		$this->load->model('m_bukukas');
		$this->load->library('upload');
		 $this->load->library('pagination'); 
		$this->load->helper(array('form', 'url','tanggal'));
		if($this->session->userdata('status') != "loginbro"  and empty($this->session->userdata('email')) ){
			$this->session->set_flashdata('msg','<div class="alert alert-danger alert-dismissible">
						<a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
						<strong> Admin Bukan Admin </strong>Ulangi Kembali
						</div> ');

			redirect(base_url("")); 
			
		}
	 
	 
	}

	 
 
	function index(){		
		$username = $this->session->userdata("username");  
		$this->db->where('username',$username);
		$query = $this->db->get('tb_admin');
		$row = $query->row();
		$data['id_admin_login']= $row->id;
		$data['id_admin']= $row->id;
		$data['nama_admin']= $row->nama_admin;
		$data['id_kantor']= $row->id_kantor;

		$id_admin = $row->id;
		$level = $row->level;
		$id_kantor = $row->id_kantor;

		date_default_timezone_get('Asia/Jakarta');
		$bulan = date('m');
		$tahun = date('Y');
		if($level =='manager'){
			$this->db->order_by('date', 'desc');
			$this->db->order_by('keterangan', 'asc');
			// $this->db->where('month(tb_bukukas.date)',$bulan);
			// $this->db->where('year(tb_bukukas.date)',$tahun);
			$query3 = $this->db->get('tb_bukukas');
			$jumlahdata=$query3->num_rows();

		}else{
			$this->db->order_by('date', 'desc');
			$this->db->order_by('keterangan', 'asc');
			// $this->db->where('month(tb_bukukas.date)',$bulan);
			// $this->db->where('year(tb_bukukas.date)',$tahun);

			$query3 = $this->db->get('tb_bukukas');
			$jumlahdata=$query3->num_rows();
		}


		$data['title1'] = 'Data Buku Kas'; 	
		$data['title2'] = 'Ubah Data'; 	
		$data['title3'] = 'Tambah Data';
		$data['title4'] = 'Buku Kas';
		$data['kontak'] = $this->m_kontak->kontak();
		$data['kantor'] = $this->m_kantor->kantor();
		$data['admin'] = $this->m_admin->data_admin();
		$data['admin_login'] = $this->m_admin->data_admin_login();  


		//konfigurasi pagination
        $config['base_url'] = site_url('bukukas/index'); //site url
        $config['total_rows'] = $jumlahdata; //total row
        $config['per_page'] = 20;  //show record per halaman
        $config["uri_segment"] = 3;  // uri parameter
        //$choice = $config["total_rows"] / $config["per_page"];
        $config["num_links"] = 50;

        // Membuat Style pagination untuk BootStrap v4
        $config['first_link']       = 'First';
        $config['last_link']        = 'Last';
        $config['next_link']        = 'Next';
        $config['prev_link']        = 'Prev';
        $config['full_tag_open']    = '<div class="pagging text-center"><nav><ul class="pagination justify-content-center">';
        $config['full_tag_close']   = '</ul></nav></div>';
        $config['num_tag_open']     = '<li class="page-item"><span class="page-link">';
        $config['num_tag_close']    = '</span></li>';
        $config['cur_tag_open']     = '<li class="page-item active"><span class="page-link">';
        $config['cur_tag_close']    = '<span class="sr-only">(current)</span></span></li>';
        $config['next_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['next_tagl_close']  = '<span aria-hidden="true">&raquo;</span></span></li>';
        $config['prev_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['prev_tagl_close']  = '</span>Next</li>';
        $config['first_tag_open']   = '<li class="page-item"><span class="page-link">';
        $config['first_tagl_close'] = '</span></li>';
        $config['last_tag_open']    = '<li class="page-item"><span class="page-link">';
        $config['last_tagl_close']  = '</span></li>';

        $this->pagination->initialize($config);
        $data['page'] = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        //panggil function get_mahasiswa_list yang ada pada mmodel mahasiswa_model. 
        $data['data'] = $this->m_bukukas->get_bukukas_list($config["per_page"], $data['page']);           

        $data['pagination'] = $this->pagination->create_links();





        $this->load->view('master/header',$data); 
        $this->load->view('master/bukukas/v_bukukas',$data);
        $this->load->view('master/footer',$data); 
    } 
	public function code_hapus(){
		$id = $this->input->post('id_bukukas');  
		 
	    $this->db->delete('tb_bukukas', array('id_bukukas' => $id)); 
	  	$this->session->set_flashdata('msg','success-hapus');
	    redirect('bukukas');
		
	}
	 
	public function code_tambah()
	{	 
		$data=array(
			'id_bukukas'=>  null,
			'keterangan'=> $this->input->post('keterangan'),
			'jenis'=> $this->input->post('jenis'),
			'nominal'=> $this->input->post('nominal'),
			'date'=> $this->input->post('date'),
			'id_admin'=> $this->input->post('id_admin'),
			 
		);

		$this->db->insert('tb_bukukas',$data);
		$this->session->set_flashdata('msg','success');
		redirect('bukukas');


 
        
        
    }  
     
	public function code_ubah() {
      
        
    	$data=array(
    	 
    		'nama_bukukas'=> $this->input->post('nama_bukukas'),
			'url_bukukas'=> url_title($this->input->post('nama_bukukas')),
			'nama_petugas'=> $this->input->post('nama_petugas'),
			'alamat'=> $this->input->post('alamat'),
			'no_hp'=> $this->input->post('no_hp'),


    	);

    	$this->db->where('id_bukukas',$this->input->post('id'));
        $this->db->update('tb_bukukas',$data);
        $this->session->set_flashdata('msg','success-edit');
    	redirect('bukukas');
	 
	} 
	 
}